using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        int N = int.Parse(Console.ReadLine());

        List<int>[] rooms = new List<int>[N + 1];
        for (int i = 1; i <= N; i++)
            rooms[i] = new List<int>();

        for (int i = 0; i < N - 1; i++)
        {
            string[] input = Console.ReadLine().Split();
            int U = int.Parse(input[0]);
            int V = int.Parse(input[1]);
            rooms[U].Add(V);
            rooms[V].Add(U);
        }
        int[] platforms = Console.ReadLine().Split().Select(int.Parse).ToArray();

        int[] changes = Console.ReadLine().Split().Select(int.Parse).ToArray();

        int[] result = new int[N];

        DFS(rooms, platforms, changes, 1, 0, result);

        Console.WriteLine(string.Join(" ", result));
    }

    static void DFS(List<int>[] rooms, int[] platforms, int[] changes, int currentRoom, int previousRoom, int[] result)
    {
        if (changes[currentRoom - 1] == 1)
            platforms[currentRoom - 1] = 1;

        if (platforms[currentRoom - 1] == 1)
            result[currentRoom - 1] = 1;

        foreach (var nextRoom in rooms[currentRoom])
        {
            if (nextRoom == previousRoom)
                continue;
            if (platforms[currentRoom - 1] == 1)
            {
                DFS(rooms, platforms, changes, nextRoom, currentRoom, result);
                result[currentRoom - 1] += result[nextRoom - 1];
            }
        }
    }
}